/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.lang.sl.SimpleSLTokenizer;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;

public class AMSService
extends FIPAService {
    public static AID getFailedReceiver(Agent a, ACLMessage failure) throws FIPAException {
        if (failure.getPerformative() != 6 || !failure.getSender().equals(a.getAMS())) {
            throw new FIPAException("Invalid AMS FAILURE message");
        }
        try {
            String content = failure.getContent();
            int start = content.indexOf("MTS-error");
            start = content.indexOf("agent-identifier", start);
            SimpleSLTokenizer parser = new SimpleSLTokenizer(content.substring(start));
            return AMSService.parseAID(parser);
        }
        catch (Exception e) {
            throw new FIPAException("Invalid content. " + e);
        }
    }

    private static AID parseAID(SimpleSLTokenizer parser) throws Exception {
        AID id = new AID("", true);
        parser.getElement();
        while (parser.nextToken().startsWith(":")) {
            Iterator it;
            String slotName = parser.getElement();
            if (slotName.equals("name")) {
                id.setName(parser.getElement());
                continue;
            }
            if (slotName.equals("addresses")) {
                it = AMSService.parseAggregate(parser).iterator();
                while (it.hasNext()) {
                    id.addAddresses((String)it.next());
                }
                continue;
            }
            if (!slotName.equals("resolvers")) continue;
            it = AMSService.parseAggregate(parser).iterator();
            while (it.hasNext()) {
                id.addResolvers((AID)it.next());
            }
        }
        parser.consumeChar(')');
        return id;
    }

    private static List parseAggregate(SimpleSLTokenizer parser) throws Exception {
        ArrayList l = new ArrayList();
        parser.consumeChar('(');
        parser.getElement();
        String next = parser.nextToken();
        while (!next.startsWith(")")) {
            if (!next.startsWith("(")) {
                l.add(parser.getElement());
            } else {
                parser.consumeChar('(');
                next = parser.nextToken();
                if (next.equals("agent-identifier")) {
                    l.add(AMSService.parseAID(parser));
                }
            }
            next = parser.nextToken();
        }
        parser.consumeChar(')');
        return l;
    }
}

